// main.c
/********************************************************************/
/* Hello World...		                               	    	    */
/* with MSP430F149 @ 8MHz	                                        */                                      
/* Thomas Wedemeyer                                                 */
/* msp430@thomas-wedemeyer.de					                    */
/*								                                    */
/* Some functions based on the MSPGCC-Examples from		            */
/* M.Mitchell (Texas Instruments, Inc) & Steve Underwood 	        */
/********************************************************************/

/*------------------------------------------------------------------------
	History:		von
	08.05.05		Thomas Wedemeyer
/*----------------------------------------------------------------------*/

/*------------------------------------------------------------------------
	Laden der Include-Files
/*----------------------------------------------------------------------*/
#include    <signal.h>
#include    <io.h>
#include    <stdio.h>
#include    "usart0.h"

const char *array="Dies ist ein langer String...\r\n";
char    buffer[40];

/*----------------------------------------------------------------------*/
//!	Setup of the Clock XTAL2
/*----------------------------------------------------------------------*/
void set_clocks()
{
    unsigned int i;

    BCSCTL1 &= ~XT2OFF;                   // XT2 = HF XTAL

    do 
    {
        IFG1 &= ~OFIFG;                       // Clear OSCFault flag
        for (i = 0xFF; i > 0; i--);           // Time for flag to set
    }
    while ((IFG1 & OFIFG) != 0);          // OSCFault flag still set? 

    BCSCTL2 |= SELM1;                     // MCLK = XT2
    BCSCTL2 |= SELS;                      // SCLK = XTAL2
    BCSCTL2 &= ~(DIVM1 | DIVM0);          // DIV = 0
 
}

/*----------------------------------------------------------------------*/
//!	Main
/*----------------------------------------------------------------------*/
int main(void)
{
    unsigned long i,j;

    WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  
    set_clocks();                         // Setup of Clocks             
    init_usart0();                          // Init of USART0                        
    _EINT();

    usart0_puts((char *)array);
    usart0_puts("Hello World\r\n");    
        
    for (;;)                              // Just Blink
    {
        for(i=0; i< 10000; i++)
        {
                 for(j = 0; j < 1000; j++);
        }    
         
        uprintf(usart0_putchar,"TESTING...TESTING: One, Two, Three... j = %ld\r\n",j);

    }  
  
  
  return 0;
}
