// USART0.c
/********************************************************************/
/* Hello World...		                               	    	    */
/* with MSP430F149 @ 8MHz	                                        */                                      
/* Thomas Wedemeyer                                                 */
/* msp430@thomas-wedemeyer.de					                    */
/*								                                    */
/* Some functions based on the MSPGCC-Examples from		            */
/* M.Mitchell (Texas Instruments, Inc) & Steve Underwood 	        */
/********************************************************************/

/*------------------------------------------------------------------------
	History:		von
	08.05.05		Thomas Wedemeyer
/*----------------------------------------------------------------------*/

#include    <signal.h>
#include    <io.h>
#include    <stdio.h>
#include    "usart0.h"

/*----------------------------------------------------------------------*/
//!	Init of USART0
/*----------------------------------------------------------------------*/
void init_usart0()
{
    UCTL0 = CHAR;                         // 8-bit character
    UTCTL0 = SSEL_SMCLK;                  // UCLK = SMCLK
    UBR00 = 0xA1;                         // 8Mhz/19200 => 416,6666
    UBR10 = 0x01;                         //
    UMCTL0 = 0x00;                        // modulation
    ME1 |= UTXE0 + URXE0;                 // Enable USART0 TXD/RXD
    IE1 |= URXIE0;                        // Enable USART0 RX interrupt
    P3SEL |= 0x30;                        // P3.4,5 = USART1 option select
    P3DIR |= 0x18;                        // P3.4, P3.3 = output direction
    P3OUT |= 0x08;                        // Enable MAX3222CA
}

/*----------------------------------------------------------------------*/
//!	USART0 Receive Interrupt handler
/*----------------------------------------------------------------------*/
interrupt (UART0RX_VECTOR) usart0_rx(void)
{
     // Echo-Funktion...
     while ((IFG1 & UTXIFG0) == 0);        // USART1 TX buffer ready?
     TXBUF0 = RXBUF0;                      // RXBUF1 to TXBUF1
 
}


/*----------------------------------------------------------------------*/
//!	USART0 Simple putchar-function without buffer and IRQ,s
/*----------------------------------------------------------------------*/
void usart0_putchar(char character)
{
     while ((IFG1 & UTXIFG0) == 0);        // USART1 TX buffer ready?
     TXBUF0 = character;                  // RXBUF0 to TXBUF1
}

/*----------------------------------------------------------------------*/
//!	USART1 Simple putstring-function without buffer and IRQ,s
/*----------------------------------------------------------------------*/
void usart0_puts(char *character)
{
    while(*character != 0)
    {
        usart0_putchar(*character);
        character++;
    }
}
